% Program Harmonic_temperature.m
%
% Calculation of temperature time series for given location xx
% and temperature profile for given time tt, for harmonic boundary 
% condition at x=0.
%
% Version 11 March 2013                       Fritz Stauffer IfU ETH Zurich
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Input of parameters
ut = 4.0;       % Thermal velocity [m/d]
Dt = 0.08;      % Thermal diffusion coefficient [m^2/d]
alpha = 50.0;   % Longitudinal thermal dispersivity [m]
T0 = 12.0;      % Mean temperature [C]
dT = 8.0;       % Temperature amplitude [K]
t0 = 0;         % Time shift [d]
tt = 183;       % Time [d]
xmax = 500;     % Maximum distance for given time tt [m]
tmax = 1827.5; % Maximum time for given location xx [d]
xx = 500.0;     % Coordinate of location xx [m]
%
omega = 2*3.14159/365.25;   % Angular frequency for period 1 y [d-1]
DL = Dt + alpha*ut;         % Longitudinal dispersion coefficient
b = sqrt((-ut*ut/(4*DL)+sqrt((ut*ut/(4*DL))^2+omega*omega))/(2*DL));
a = (omega-b*ut)/(2*b*DL);
%
% Calculation of temperature for given time tt and figure 1
dx = xmax/200;
x=0:dx:xmax;
T=zeros(1,251);
T=T0 + dT*exp(-a*x).*cos(-b*x+omega*(tt-t0));
figure;
plot(x,T,'r');
axis ([0 xmax floor(T0-dT-2) ceil(T0+dT+2)]);
xlabel ('Location x [m]');
ylabel ('Temperature [C]');
title (strcat('Harmonic temperature for given time t=',num2str(tt),' d'));
grid on;
%
% Calculation of temperature for location xx and figure 2
dt = tmax/200;
t=0:dt:tmax;
T=zeros(1,251);
T=T0 + dT*exp(-a*xx).*cos(-b*xx+omega*(t-t0));
figure;
plot(t,T,'r');
axis ([0 tmax floor(T0-dT-2) ceil(T0+dT+2)]);
xlabel ('Time t [d]');
ylabel ('Temperature [C]');
title (strcat('Harmonic temperature for given location x=',num2str(xx),' m'));
grid on;
% end
